/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.silverminer.shrines.commands.LocateInBiomeCommand;
import com.silverminer.shrines.commands.VariationCommand;
import com.silverminer.shrines.config.ShrinesConfig;
import com.silverminer.shrines.registries.ConfiguredStructureFeatureRegistry;
import com.silverminer.shrines.registries.PlacementCalculatorTypeRegistry;
import com.silverminer.shrines.registries.RandomVariationConfigRegistry;
import com.silverminer.shrines.registries.RandomVariationMaterialRegistry;
import com.silverminer.shrines.registries.SpawnCriteriaTypeRegistry;
import com.silverminer.shrines.registries.StructureRegistry;
import com.silverminer.shrines.registries.StructureSetRegistry;
import com.silverminer.shrines.registries.TemplatePoolRegistry;
import com.silverminer.shrines.update.Updater;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterStructureConversionsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="shrines")
public class Shrines {
    public static final String MODID = "shrines";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static String VERSION = "N/A";

    public Shrines() {
        this.registerExtensionPoint();
        this.printShrinesVersion();
        this.registerEvents();
        this.registerRegistries();
        this.registerConfig();
    }

    private void registerExtensionPoint() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    private void printShrinesVersion() {
        ModList.get().getModContainerById(MODID).ifPresent(container -> {
            VERSION = container.getModInfo().getVersion().toString();
        });
        LOGGER.info("Shrines " + VERSION + " initialized");
    }

    private void registerConfig() {
        FileUtils.getOrCreateDirectory((Path)FMLPaths.CONFIGDIR.get().resolve(MODID), (String)MODID);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ShrinesConfig.GENERAL_SPEC, "shrines/settings.toml");
    }

    private void runUpdater() {
        Path minecraftDir = FMLPaths.GAMEDIR.get();
        Path oldPackDir = minecraftDir.resolve("shrines-data").resolve("3.x.x").resolve("Packets");
        Path newPackDir = minecraftDir.resolve("datapacks");
        if (((Boolean)ShrinesConfig.runStructureUpdater.get()).booleanValue() && Files.exists(oldPackDir, new LinkOption[0])) {
            try {
                Updater.updateAll(oldPackDir, newPackDir);
                ShrinesConfig.runStructureUpdater.set((Object)false);
            }
            catch (Exception e) {
                LOGGER.error("Failed to update old structures", (Throwable)e);
            }
        }
    }

    private void registerEvents() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(event -> {
            PackSource source = PackSource.m_10533_((String)"pack.source.shrines");
            event.addRepositorySource((RepositorySource)new FolderRepositorySource(FMLPaths.GAMEDIR.get().resolve("datapacks").toFile(), source));
        });
        modBus.addListener(event -> event.enqueueWork(this::runUpdater));
        MinecraftForge.EVENT_BUS.addListener(event -> {
            VariationCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            LocateInBiomeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        });
        MinecraftForge.EVENT_BUS.addListener(Shrines::registerStructureConversions);
    }

    private void registerRegistries() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        StructureRegistry.STRUCTURES.register(modBus);
        SpawnCriteriaTypeRegistry.SPAWN_CRITERIA_TYPE_REGISTRY.register(modBus);
        PlacementCalculatorTypeRegistry.PLACEMENT_CALCULATOR_TYPE_DEFERRED_REGISTER.register(modBus);
        ConfiguredStructureFeatureRegistry.REGISTRY.register(modBus);
        TemplatePoolRegistry.REGISTRY.register(modBus);
        StructureSetRegistry.REGISTRY.register(modBus);
        RandomVariationMaterialRegistry.REGISTRY.register(modBus);
        RandomVariationConfigRegistry.REGISTRY.register(modBus);
    }

    private static void registerStructureConversions(@NotNull RegisterStructureConversionsEvent event) {
        event.register("shrines:ballon", StructuresBecomeConfiguredFix.Conversion.m_207746_((String)"shrines:balloon"));
        event.register("shrines:high_tempel", StructuresBecomeConfiguredFix.Conversion.m_207746_((String)"shrines:high_temple"));
        event.register("shrines:small_tempel", StructuresBecomeConfiguredFix.Conversion.m_207746_((String)"shrines:small_temple"));
        event.register("shrines:player_house", StructuresBecomeConfiguredFix.Conversion.m_207746_((String)"shrines:tall_player_house"));
        for (String structure : (List)ShrinesConfig.removedStructures.get()) {
            try {
                event.register(structure, StructuresBecomeConfiguredFix.Conversion.m_207746_((String)ConfiguredStructureFeatureRegistry.DELETED_STRUCTURE.getId().toString()));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new RuntimeException("You've miss-configured shrines removed structures: " + e);
            }
        }
    }

    @NotNull
    public static ResourceLocation location(@NotNull String path) {
        return new ResourceLocation(MODID, path);
    }

    public static boolean invalidateStructure(@NotNull RegistryAccess registryAccess, ConfiguredStructureFeature<?, ?> configuredStructureFeature) {
        Registry registry = registryAccess.m_175515_(Registry.f_122882_);
        ResourceLocation id = registry.m_7981_(configuredStructureFeature);
        if (id != null) {
            ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)id);
            Holder.Reference holder = Holder.Reference.m_205766_((Registry)registry, (ResourceKey)resourceKey);
            for (String structure : (List)ShrinesConfig.disabledStructures.get()) {
                TagKey tagKey;
                if (!(structure.startsWith("#") ? registry.m_203431_(tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation(structure.substring(1)))).map(arg_0 -> Shrines.lambda$invalidateStructure$7((Holder)holder, arg_0)).orElse(false) != false : id.toString().equals(structure))) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ Boolean lambda$invalidateStructure$7(Holder holder, HolderSet.Named tag) {
        return tag.m_203333_(holder);
    }
}

